;        (C) COPYRIGHT 1991-1994 BY SOFTDESK, INC. ALL RIGHTS RESERVED.
;
;***************************************************************************
;*                        !!!! NOTICE TO USERS !!!!                        *
;*  THE MATERIAL CONTAINED IN THIS FILE IS OPEN TO THE USER TO EXAMINE     *
;*  AND MODIFY.  UNDER NO CONDITIONS SHOULD THIS MATERIAL BE DUPLICATED    *
;*  OR RE-DISTRIBUTED BY OR TO PERSONS OTHER THAN THOSE WHO HAVE A VALID   *
;*  REGESTERED COPY OF THE SOFTDESK CORE PROGRAM.                          *
;***************************************************************************

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   THIS IS A PORTION OF THE SDSK MACROS.LSP FILE
;   WITH MODIFICATIONS NOT BY SOFTDESK.  TO USE THESE ALTERNATE VERSIONS, THE
;   ORIGINALS IN THE MACROS LISP FILE NEED TO DEACTIVATED AS MACROS.LSP LOADS
;   LAST.   MODIFICATIONS ARE SHOWN IN UPPERCASE.  FILE NAME:  V_SDSK.LSP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:dal ( / PSTY PLAY)                         ;; DIM-ALLIGNED
  (CKDIMS)                                          
  (cr_mnl)                                          
  (zz_menucall '("s=acadx" "s=dim") nil 3)          
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Aligned dimension")
  (IF (/= nil G_DETMOD)                                    
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_ali")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)

(defun c:dba ( / PSTY PLAY)                          ;; DIM-BASE
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Baseline dimension")
  (IF (/= nil G_DETMOD)                                    
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_baseline")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dco ( / PSTY PLAY)                          ;; DIM-CONTINUE
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Continue dimensioning")
  (IF (/= nil G_DETMOD)                
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_cont")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:ddi ( / PSTY PLAY)                          ;; DIM-DIAMETER
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Diameter dimension")
  (IF (/= nil G_DETMOD)                                   
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_dia")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dan ( / PSTY PLAY)                          ;; DIM-ANGULAR
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Angular dimension")
  (IF (/= nil G_DETMOD)                                    
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_ang")
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dho ( / PLAY PSTY)                           ;; DIM-HORIZONTAL
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Horizontal dimension")
  (IF (/= nil G_DETMOD)                                    
    (SETVAR "DIMSCALE" G_DDSC)
  )
  (command "_.dim1")
  (zz_pausecom "_horiz")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)

(defun c:dle ( / PLAY PSTY)                            ;; DIM-LEADER
  (CKDIMS)
  (cr_mnl)                         
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Dimension Leader")
  (IF (/= nil G_DETMOD)         
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (if (member "PP" zz#appl)
    (progn
      (zz_load "ZA" "leader" zz_leader zz#t nil)
      (zz_leader nil 0.0 zz#t nil zz#t)
    )
    (zz_mprompt "CR" 0 "\nMacro requires Productivity Tools")
  )
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dce ( / PSTY PLAY)                      ;; DIM-CENTER
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Center marks")
  (IF (/= nil G_DETMOD)                         
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_cen")
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)

(defun c:dob ( / PSTY PLAY)                           ;; DIM-OBLIQUE
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Oblique dimension")
  (IF (/= nil G_DETMOD)                             
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim" "_oblique")
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dor ( / PSTY PLAY)                             ;; DIM-ORDANATE
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Ordinate dimension")
  (IF (/= nil G_DETMOD)                    
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_ord")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
  
(defun c:dra ( / PSTY PLAY)                             ;; DIM-RADIUS
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Radius dimension")
  (IF (/= nil G_DETMOD)                            
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_rad")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)

(defun c:dro ( / PSTY PLAY)                             ;; DIM-ROTATED
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (zz_mprompt "CR" 0 "\nMacro: Rotate dimension")
  (zz_style_c "DIMTEXT")
  (zz_layer_m "DIMLINE")
  (zz_setdimsty nil zz#t nil zz#t)
  (zz_post)
  (IF (/= nil G_DETMOD)                                    
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim" "_rotated")
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)

(defun c:dve ( / PLAY PSTY)                              ;; DIM-VERTICAL
  (CKDIMS)
  (cr_mnl)
  (zz_menucall '("s=acadx" "s=dim") nil 3)
  (cr_dimprep)
  (zz_mprompt "CR" 0 "\nMacro: Vertical dimension")
  (IF (/= nil G_DETMOD)                               
    (SETVAR "DIMSCALE" g_ddsc)
  )
  (command "_.dim1")
  (zz_pausecom "_vert")
  (cr_specfrac)
  (SETVAR "TEXTSTYLE" PSTY)
  (SETVAR "CLAYER" PLAY)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(DEFUN CKDIMS ()                                        ;; CALLED FROM THE
  (SETQ PSTY (GETVAR "TEXTSTYLE"))                      ;; DIM MACROS ABOVE
  (SETQ PLAY (GETVAR "CLAYER"))                         ;; !!!! IMPORTANT !!!
  (IF (= NIL (TBLSEARCH "STYLE" "DIMTEXT"))             ;; DIMTEXT IS THE TEXTSTYLE
    (PROGN                                              ;; & MAY BE CHANGED
      (COMMAND "STYLE" "DIMTEXT" "TXT" 0 1 0 "N" "N")   ;;"TXT" IS THE FONT
      (IF (= (GETVAR "CMDNAMES") "STYLE")               ;; & MAY BE CHANGED
        (COMMAND "n")
      )
    )      
    (SETVAR "TEXTSTYLE" "DIMTEXT") 
  )                                
  (PRINC)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:l ( / )                                        ;; LINE COMMAND 
  (IF (= NIL G_DETMOD)                                  ;; WILL NOT USE SDSK
    (PROGN                                              ;; ENHANCED VERSION IF
      (cr_mnl)                                          ;; "MULTI-SCALE"
      (zz_menucall '("s=acadx" "s=line") nil 3)         ;; IS ACTIVE
      (zz_mprompt "CR" 0 "\nMacro: Line")
      (if (member "PP" zz#appl)                         ;; SDSK VERSION   
        (progn                                          ;; RESETS DIMSCALE
          (zz_load "PP" "sline" pp_sline nil nil)  
          (pp_sline)            
        )
        (command "_.line")
      )
    )
    (COMMAND "_.LINE")  ;; ELSE MULTI-SCALE ACTIVE
  )
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:s ( / )                                       ;; STRETCH COMMAND
  (IF (= NIL G_DETMOD)
    (PROGN
      (cr_mnl)                                           ;; WILL NOT USE SDSK
      (zz_menucall '("s=acadx" "s=stretch") nil 3)       ;; VERSION IF
      (zz_mprompt "CR" 0 "\nMacro: Stretch")             ;; MULTI-SCALE ACTIVE
      ; Note: the following code is for Auto-arch special 
      ; stretch of wall hatch
      (if (member "AB" zz#appl) 
        (progn
          (zz_load "AB" "stretch" ab_stretch zz#t nil)
          (ab_stretch)
        )
        (progn
          (zz_mprompt "CR" 0 "\nSelect objects with Crossing window: ") 
          (zz_dimsaf) 
          (zz_mprompt "CR" 0 "\nFirst corner: ") 
          (command "_.stretch" "_c" pause) 
          (zz_mprompt "CR" 0 "Other corner: ") 
          (command pause "_R")
        )
      ) 
    )
    (PROGN
      (PROMPT "\nStretch")
      (COMMAND "_.stretch")
    )
  )
  (princ)
) 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:sv ( / )                   ;; SYSTEM VARIABLES DISPLAY/SET
  (IF (/= "" G_MDF)
    (SETVAR "MODEMACRO" "")           
  )
  (cr_mnl)
  (zz_mprompt "CR" 0 "\nMacro: System Variables")
  (cr_acadvars)
  (IF (/= "" G_MDF)
    (LOAD G_MDF)                    ;; RELOAD IF SET IN V_SETVAR.LSP
  )
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:d ( / )                    ;; DRAW BY EXAMPLE
  (SETQ PELV (GETVAR "ELEVATION")
        PCOL (GETVAR "CECOLOR")
        PLAY (GETVAR "CLAYER")
        PLIN (GETVAR "CELTYPE")
        PTHK (GETVAR "THICKNESS")
        PWID (GETVAR "PLINEWID")
  )
  (cr_mnl)
  (zz_mprompt "CR" 0 "\nMacro: Draw by Example")
  (if (member "PP" zz#appl)
    (PROGN
      (pp_ddraw)
      (WHILE (= (GETVAR "CMDACTIVE") 1)
        (COMMAND PAUSE)
      )
      (SETVAR "ELEVATION" PELV)     ;; RESET ENTITY CREATION PROPS
      (SETVAR "CECOLOR" PCOL)       ;; AFTER COMMAND
      (SETVAR "CLAYER" PLAY)
      (SETVAR "CELTYPE" PLIN)
      (SETVAR "THICKNESS" PTHK)
      (SETVAR "PLINEWID" PWID)
      (IF (/= nil G_DETMOD)                                    
        (SETVAR "DIMSCALE" g_ddsc)
      )
    )
    (zz_mprompt "CR" 0 "\nMacro requires Productivity Tools")
  )
  (princ)
)


